var NAVTREE =
[
  [ "VSTGUI", "index.html", [
    [ "Introduction", "index.html#intro", null ],
    [ "Setup", "page_setup.html", null ],
    [ "New stuff in VSTGUI 4", "page_news_and_changes.html", "page_news_and_changes" ],
    [ "Getting Started Tutorial (VST 2.x)", "page_vst2_tutorial.html", [
      [ "VST Integration", "page_vst2_tutorial.html#vstintegration", null ],
      [ "Adding views and controls", "page_vst2_tutorial.html#addingviewsandcontrols", [
        [ "Loading images", "page_vst2_tutorial.html#loading_bitmaps", null ],
        [ "Creating views and adding them to the frame", "page_vst2_tutorial.html#adding_views", null ],
        [ "Creating a knob control", "page_vst2_tutorial.html#adding_knob", null ]
      ] ],
      [ "Getting notification of control changes", "page_vst2_tutorial.html#controllistener", [
        [ "The CControlListener", "page_vst2_tutorial.html#TheCControlListener", null ],
        [ "Control identification", "page_vst2_tutorial.html#ControlIdentification", null ]
      ] ]
    ] ],
    [ "Changelog", "page_changelog.html", null ],
    [ "License", "page_license.html", null ],
    [ "Animations", "page_animation.html", [
      [ "The Animator", "page_animation.html#the_animator", null ],
      [ "The Animation", "page_animation.html#the_animation", [
        [ "The Animation Target", "page_animation.html#animation_target", null ],
        [ "The Animation Timing Function", "page_animation.html#animation_timing", null ]
      ] ],
      [ "Simple Usage Example", "page_animation.html#simple_example", null ]
    ] ],
    [ "Creating User Interfaces via XML", "uidescription.html", "uidescription" ],
    [ "Inline UI Editing for VST3 (WYSIWYG)", "page_vst3_inline_editing.html", [
      [ "Introduction", "page_vst3_inline_editing.html#vst3_intro", null ],
      [ "Setup", "page_vst3_inline_editing.html#vst3_setup", null ],
      [ "Building and editing", "page_vst3_inline_editing.html#building_editing", [
        [ "VSTGUI Inspector", "page_vst3_inline_editing.html#vstgui_inspector", null ],
        [ "Attributes Tab", "page_vst3_inline_editing.html#vstgui_inspector_attributes", null ],
        [ "Bitmaps Tab", "page_vst3_inline_editing.html#vstgui_inspector_bitmaps", null ],
        [ "Colors Tab", "page_vst3_inline_editing.html#vstgui_inspector_colors", null ],
        [ "Fonts Tab", "page_vst3_inline_editing.html#vstgui_inspector_fonts", null ],
        [ "Tags Tab", "page_vst3_inline_editing.html#vstgui_inspector_tags", null ],
        [ "Context Menu", "page_vst3_inline_editing.html#contextmenu", null ]
      ] ],
      [ "Parameter Binding", "page_vst3_inline_editing.html#parameter_binding", null ],
      [ "Creating Custom Views", "page_vst3_inline_editing.html#custom_view_creation", null ],
      [ "Sub-Controllers", "page_vst3_inline_editing.html#sub_controllers", null ],
      [ "Templates", "page_vst3_inline_editing.html#templates", null ],
      [ "Misc", "page_vst3_inline_editing.html#vst3_misc", null ]
    ] ],
    [ "New Inline UI Editor for VST3 (WYSIWYG)", "page_uidescription_editor.html", [
      [ "Introduction", "page_uidescription_editor.html#ui_editor_intro", null ],
      [ "Preparation", "page_uidescription_editor.html#ui_editor_preparation", null ],
      [ "Parameter Binding", "page_uidescription_editor.html#ui_editor_parameter_binding", null ],
      [ "The Editor", "page_uidescription_editor.html#ui_editor_the_editor", [
        [ "Toolbar", "page_uidescription_editor.html#the_editor_toolbar", null ],
        [ "Template Editor", "page_uidescription_editor.html#the_editor_template_editor", null ],
        [ "View Attribute Editor", "page_uidescription_editor.html#the_editor_view_attribute_editor", null ],
        [ "Template Selector + View Hierarchy Browser", "page_uidescription_editor.html#the_editor_template_view_hierarchy", null ],
        [ "View Palette + Global UI Properties Editor", "page_uidescription_editor.html#the_editor_view_palette_globals", [
          [ "Views", "page_uidescription_editor.html#the_editor_view_palette_globals_view", null ],
          [ "Tags", "page_uidescription_editor.html#the_editor_view_palette_globals_tags", null ],
          [ "Colors", "page_uidescription_editor.html#the_editor_view_palette_globals_colors", null ],
          [ "Bitmaps", "page_uidescription_editor.html#the_editor_view_palette_globals_bitmaps", null ],
          [ "Fonts", "page_uidescription_editor.html#the_editor_view_palette_globals_fonts", null ]
        ] ]
      ] ],
      [ "Creating Custom Views", "page_uidescription_editor.html#ui_editor_custom_view_creation", null ],
      [ "Sub-Controllers", "page_uidescription_editor.html#ui_editor_sub_controllers", null ],
      [ "Templates", "page_uidescription_editor.html#ui_editor_templates", null ]
    ] ],
    [ "Keyboard Event Flow", "key_event_flow.html", [
      [ "Short Story", "key_event_flow.html#short_story", null ],
      [ "Long Story", "key_event_flow.html#long_story", null ]
    ] ],
    [ "Deprecated List", "deprecated.html", null ],
    [ "Modules", "modules.html", "modules" ],
    [ "Namespaces", null, [
      [ "Namespace List", "namespaces.html", "namespaces" ],
      [ "Namespace Members", "namespacemembers.html", [
        [ "All", "namespacemembers.html", "namespacemembers_dup" ],
        [ "Functions", "namespacemembers_func.html", null ],
        [ "Variables", "namespacemembers_vars.html", "namespacemembers_vars" ],
        [ "Typedefs", "namespacemembers_type.html", null ],
        [ "Enumerations", "namespacemembers_enum.html", null ],
        [ "Enumerator", "namespacemembers_eval.html", null ]
      ] ]
    ] ],
    [ "Classes", null, [
      [ "Class List", "annotated.html", "annotated" ],
      [ "Class Index", "classes.html", null ],
      [ "Class Hierarchy", "hierarchy.html", "hierarchy" ],
      [ "Class Members", "functions.html", [
        [ "All", "functions.html", "functions_dup" ],
        [ "Functions", "functions_func.html", "functions_func" ],
        [ "Variables", "functions_vars.html", "functions_vars" ],
        [ "Typedefs", "functions_type.html", null ],
        [ "Enumerations", "functions_enum.html", null ],
        [ "Enumerator", "functions_eval.html", null ]
      ] ]
    ] ]
  ] ]
];

var NAVTREEINDEX =
[
"annotated.html",
"class_v_s_t_g_u_i_1_1_animation_1_1_repeat_timing_function.html#a4721980fb080121f8bd6b82e16c39c64",
"class_v_s_t_g_u_i_1_1_c_anim_knob.html#a7c938477f787fe59b0eacb147a8c03a5",
"class_v_s_t_g_u_i_1_1_c_animation_splash_screen.html#a42f83a1586dca990960e415e01ba259c",
"class_v_s_t_g_u_i_1_1_c_animation_splash_screen.html#aec1573cc64ee895b86904c04fe0d1103",
"class_v_s_t_g_u_i_1_1_c_auto_layout_container_view.html#a2881def78e7d6c57807b03913fa3cdde",
"class_v_s_t_g_u_i_1_1_c_check_box.html#a1a94611c827c03e0f7d973c1abc33f7b",
"class_v_s_t_g_u_i_1_1_c_check_box.html#ac8855959285a9555faaa8b0313e07027",
"class_v_s_t_g_u_i_1_1_c_color_chooser.html#aefb9b7d4e42fb95ea30e67e10001650e",
"class_v_s_t_g_u_i_1_1_c_data_browser.html#a05589fbab0657f08285ebdfe93f5ec9ea7bc457f304bba59d89efe7d5f84628aa",
"class_v_s_t_g_u_i_1_1_c_draw_context.html#a22b991c831981b7fb1d13420ee518b12",
"class_v_s_t_g_u_i_1_1_c_font_chooser.html#a7d82e50d9ee3c1b4c8521c83d0534b3d",
"class_v_s_t_g_u_i_1_1_c_frame.html#a8702ff2f7885f8d7a93bde675d32f1dc",
"class_v_s_t_g_u_i_1_1_c_gradient_view.html#adeff9bf0c8c59dd08126de1ea167cfee",
"class_v_s_t_g_u_i_1_1_c_horizontal_slider.html#ae0cd41adfb11745650b23cfff1dde454",
"class_v_s_t_g_u_i_1_1_c_kick_button.html#a231289d0aa4c6c85931a822afab8b2bf",
"class_v_s_t_g_u_i_1_1_c_knob.html#a74a4fef159b20ca6da9f8b566f3b8072",
"class_v_s_t_g_u_i_1_1_c_layered_view_container.html#a63c089ab257f98278f33085283e17d10",
"class_v_s_t_g_u_i_1_1_c_memory_stream.html#a61473f403b372a31b682b882096d3193",
"class_v_s_t_g_u_i_1_1_c_movie_bitmap.html#ae57d02e392f1505445a7d83f1a18d96c",
"class_v_s_t_g_u_i_1_1_c_nine_part_tiled_bitmap.html#a624f67fa321bcb03a632d38161b1f216",
"class_v_s_t_g_u_i_1_1_c_on_off_button.html#ad1bb542701081a3b8e7a2fffcc465e1a",
"class_v_s_t_g_u_i_1_1_c_option_menu.html#a63c089ab257f98278f33085283e17d10",
"class_v_s_t_g_u_i_1_1_c_param_display.html#a686daf79492a0ddd71ee15309c5cab96",
"class_v_s_t_g_u_i_1_1_c_rocker_switch.html#a624f67fa321bcb03a632d38161b1f216",
"class_v_s_t_g_u_i_1_1_c_row_column_view.html#a60ad2aca49fcfc7cd997f5355b62b148",
"class_v_s_t_g_u_i_1_1_c_scroll_view.html#a1a94611c827c03e0f7d973c1abc33f7b",
"class_v_s_t_g_u_i_1_1_c_scrollbar.html#a5229f5e751d2e25e9d81ba619455a25c",
"class_v_s_t_g_u_i_1_1_c_segment_button.html#a91356b5d5ba1b7dd4e9661acef19bfdf",
"class_v_s_t_g_u_i_1_1_c_shadow_view_container.html#a7c938477f787fe59b0eacb147a8c03a5",
"class_v_s_t_g_u_i_1_1_c_slider.html#a46c8a310cf4c094f8c80e1cb8dc1f911",
"class_v_s_t_g_u_i_1_1_c_special_digit.html#a701d6a482c7f94c8988bb495b5388e31",
"class_v_s_t_g_u_i_1_1_c_splash_screen.html#ad4cade1e0f82dfac0b5f997a5c482c93",
"class_v_s_t_g_u_i_1_1_c_split_view.html#aa053942a502bdcf882888ab77b7a3b45",
"class_v_s_t_g_u_i_1_1_c_tab_view.html#a701d6a482c7f94c8988bb495b5388e31",
"class_v_s_t_g_u_i_1_1_c_text_button.html#a4b798253dd80ae013643a26e88e2bf6a",
"class_v_s_t_g_u_i_1_1_c_text_button.html#adf44adf5f94f901908fe85c065a71f62",
"class_v_s_t_g_u_i_1_1_c_text_edit.html#ac37014b2e7e2a160edf3d7235da6f825aace98f0ecd0d929b4e83a7e3603e9226",
"class_v_s_t_g_u_i_1_1_c_text_label.html#ac73f52148f1313a35ef4030306c21333",
"class_v_s_t_g_u_i_1_1_c_vertical_slider.html#aac4c8479129a3591ef90cfb40976b840",
"class_v_s_t_g_u_i_1_1_c_vertical_switch.html#ae9c78e79695855e5e9a0cae27ca042c9",
"class_v_s_t_g_u_i_1_1_c_view_container.html#ad09d7158c9aa1702bff4314320eb2fae",
"class_v_s_t_g_u_i_1_1_c_x_y_pad.html#a0da2921daab737ff234d0be636a917b6",
"class_v_s_t_g_u_i_1_1_generic_string_list_data_browser_source.html#a646a2b37a6e47ae7cb9d7d9956416d99",
"class_v_s_t_g_u_i_1_1_i_view_factory.html#a723f2d60a2aca49c55737f4773f6d0a4",
"class_v_s_t_g_u_i_1_1_u_i_description.html#ab892936eb26514fb254970fbc3305b26",
"class_v_s_t_g_u_i_1_1_u_i_view_switch_container.html#af3afd0415705c5d1bd83201846ade4a3",
"functions_h.html",
"struct_v_s_t_g_u_i_1_1_c_control_private_1_1_control_listener_call.html"
];

var SYNCONMSG = 'click to disable panel synchronisation';
var SYNCOFFMSG = 'click to enable panel synchronisation';
var navTreeSubIndices = new Array();

function getData(varName)
{
  var i = varName.lastIndexOf('/');
  var n = i>=0 ? varName.substring(i+1) : varName;
  return eval(n.replace(/\-/g,'_'));
}

function stripPath(uri)
{
  return uri.substring(uri.lastIndexOf('/')+1);
}

function stripPath2(uri)
{
  var i = uri.lastIndexOf('/');
  var s = uri.substring(i+1);
  var m = uri.substring(0,i+1).match(/\/d\w\/d\w\w\/$/);
  return m ? uri.substring(i-6) : s;
}

function hashValue()
{
  return $(location).attr('hash').substring(1).replace(/[^\w\-]/g,'');
}

function hashUrl()
{
  return '#'+hashValue();
}

function pathName()
{
  return $(location).attr('pathname').replace(/[^-A-Za-z0-9+&@#/%?=~_|!:,.;\(\)]/g, '');
}

function localStorageSupported()
{
  try {
    return 'localStorage' in window && window['localStorage'] !== null && window.localStorage.getItem;
  }
  catch(e) {
    return false;
  }
}


function storeLink(link)
{
  if (!$("#nav-sync").hasClass('sync') && localStorageSupported()) {
      window.localStorage.setItem('navpath',link);
  }
}

function deleteLink()
{
  if (localStorageSupported()) {
    window.localStorage.setItem('navpath','');
  }
}

function cachedLink()
{
  if (localStorageSupported()) {
    return window.localStorage.getItem('navpath');
  } else {
    return '';
  }
}

function getScript(scriptName,func,show)
{
  var head = document.getElementsByTagName("head")[0]; 
  var script = document.createElement('script');
  script.id = scriptName;
  script.type = 'text/javascript';
  script.onload = func; 
  script.src = scriptName+'.js'; 
  if ($.browser.msie && $.browser.version<=8) { 
    // script.onload does not work with older versions of IE
    script.onreadystatechange = function() {
      if (script.readyState=='complete' || script.readyState=='loaded') { 
        func(); if (show) showRoot(); 
      }
    }
  }
  head.appendChild(script); 
}

function createIndent(o,domNode,node,level)
{
  var level=-1;
  var n = node;
  while (n.parentNode) { level++; n=n.parentNode; }
  if (node.childrenData) {
    var imgNode = document.createElement("img");
    imgNode.style.paddingLeft=(16*level).toString()+'px';
    imgNode.width  = 16;
    imgNode.height = 22;
    imgNode.border = 0;
    node.plus_img = imgNode;
    node.expandToggle = document.createElement("a");
    node.expandToggle.href = "javascript:void(0)";
    node.expandToggle.onclick = function() {
      if (node.expanded) {
        $(node.getChildrenUL()).slideUp("fast");
        node.plus_img.src = node.relpath+"ftv2pnode.png";
        node.expanded = false;
      } else {
        expandNode(o, node, false, false);
      }
    }
    node.expandToggle.appendChild(imgNode);
    domNode.appendChild(node.expandToggle);
    imgNode.src = node.relpath+"ftv2pnode.png";
  } else {
    var span = document.createElement("span");
    span.style.display = 'inline-block';
    span.style.width   = 16*(level+1)+'px';
    span.style.height  = '22px';
    span.innerHTML = '&#160;';
    domNode.appendChild(span);
  } 
}

var animationInProgress = false;

function gotoAnchor(anchor,aname,updateLocation)
{
  var pos, docContent = $('#doc-content');
  var ancParent = $(anchor.parent());
  if (ancParent.hasClass('memItemLeft') ||
      ancParent.hasClass('fieldname') ||
      ancParent.hasClass('fieldtype') ||
      ancParent.is(':header'))
  {
    pos = ancParent.position().top;
  } else if (anchor.position()) {
    pos = anchor.position().top;
  }
  if (pos) {
    var dist = Math.abs(Math.min(
               pos-docContent.offset().top,
               docContent[0].scrollHeight-
               docContent.height()-docContent.scrollTop()));
    animationInProgress=true;
    docContent.animate({
      scrollTop: pos + docContent.scrollTop() - docContent.offset().top
    },Math.max(50,Math.min(500,dist)),function(){
      if (updateLocation) window.location.href=aname;
      animationInProgress=false;
    });
  }
}

function newNode(o, po, text, link, childrenData, lastNode)
{
  var node = new Object();
  node.children = Array();
  node.childrenData = childrenData;
  node.depth = po.depth + 1;
  node.relpath = po.relpath;
  node.isLast = lastNode;

  node.li = document.createElement("li");
  po.getChildrenUL().appendChild(node.li);
  node.parentNode = po;

  node.itemDiv = document.createElement("div");
  node.itemDiv.className = "item";

  node.labelSpan = document.createElement("span");
  node.labelSpan.className = "label";

  createIndent(o,node.itemDiv,node,0);
  node.itemDiv.appendChild(node.labelSpan);
  node.li.appendChild(node.itemDiv);

  var a = document.createElement("a");
  node.labelSpan.appendChild(a);
  node.label = document.createTextNode(text);
  node.expanded = false;
  a.appendChild(node.label);
  if (link) {
    var url;
    if (link.substring(0,1)=='^') {
      url = link.substring(1);
      link = url;
    } else {
      url = node.relpath+link;
    }
    a.className = stripPath(link.replace('#',':'));
    if (link.indexOf('#')!=-1) {
      var aname = '#'+link.split('#')[1];
      var srcPage = stripPath(pathName());
      var targetPage = stripPath(link.split('#')[0]);
      a.href = srcPage!=targetPage ? url : "javascript:void(0)"; 
      a.onclick = function(){
        storeLink(link);
        if (!$(a).parent().parent().hasClass('selected'))
        {
          $('.item').removeClass('selected');
          $('.item').removeAttr('id');
          $(a).parent().parent().addClass('selected');
          $(a).parent().parent().attr('id','selected');
        }
        var anchor = $(aname);
        gotoAnchor(anchor,aname,true);
      };
    } else {
      a.href = url;
      a.onclick = function() { storeLink(link); }
    }
  } else {
    if (childrenData != null) 
    {
      a.className = "nolink";
      a.href = "javascript:void(0)";
      a.onclick = node.expandToggle.onclick;
    }
  }

  node.childrenUL = null;
  node.getChildrenUL = function() {
    if (!node.childrenUL) {
      node.childrenUL = document.createElement("ul");
      node.childrenUL.className = "children_ul";
      node.childrenUL.style.display = "none";
      node.li.appendChild(node.childrenUL);
    }
    return node.childrenUL;
  };

  return node;
}

function showRoot()
{
  var headerHeight = $("#top").height();
  var footerHeight = $("#nav-path").height();
  var windowHeight = $(window).height() - headerHeight - footerHeight;
  (function (){ // retry until we can scroll to the selected item
    try {
      var navtree=$('#nav-tree');
      navtree.scrollTo('#selected',0,{offset:-windowHeight/2});
    } catch (err) {
      setTimeout(arguments.callee, 0);
    }
  })();
}

function expandNode(o, node, imm, showRoot)
{
  if (node.childrenData && !node.expanded) {
    if (typeof(node.childrenData)==='string') {
      var varName    = node.childrenData;
      getScript(node.relpath+varName,function(){
        node.childrenData = getData(varName);
        expandNode(o, node, imm, showRoot);
      }, showRoot);
    } else {
      if (!node.childrenVisited) {
        getNode(o, node);
      } if (imm || ($.browser.msie && $.browser.version>8)) { 
        // somehow slideDown jumps to the start of tree for IE9 :-(
        $(node.getChildrenUL()).show();
      } else {
        $(node.getChildrenUL()).slideDown("fast");
      }
      if (node.isLast) {
        node.plus_img.src = node.relpath+"ftv2mlastnode.png";
      } else {
        node.plus_img.src = node.relpath+"ftv2mnode.png";
      }
      node.expanded = true;
    }
  }
}

function glowEffect(n,duration)
{
  n.addClass('glow').delay(duration).queue(function(next){
    $(this).removeClass('glow');next();
  });
}

function highlightAnchor()
{
  var aname = hashUrl();
  var anchor = $(aname);
  if (anchor.parent().attr('class')=='memItemLeft'){
    var rows = $('.memberdecls tr[class$="'+hashValue()+'"]');
    glowEffect(rows.children(),300); // member without details
  } else if (anchor.parent().attr('class')=='fieldname'){
    glowEffect(anchor.parent().parent(),1000); // enum value
  } else if (anchor.parent().attr('class')=='fieldtype'){
    glowEffect(anchor.parent().parent(),1000); // struct field
  } else if (anchor.parent().is(":header")) {
    glowEffect(anchor.parent(),1000); // section header
  } else {
    glowEffect(anchor.next(),1000); // normal member
  }
  gotoAnchor(anchor,aname,false);
}

function selectAndHighlight(hash,n)
{
  var a;
  if (hash) {
    var link=stripPath(pathName())+':'+hash.substring(1);
    a=$('.item a[class$="'+link+'"]');
  }
  if (a && a.length) {
    a.parent().parent().addClass('selected');
    a.parent().parent().attr('id','selected');
    highlightAnchor();
  } else if (n) {
    $(n.itemDiv).addClass('selected');
    $(n.itemDiv).attr('id','selected');
  }
  if ($('#nav-tree-contents .item:first').hasClass('selected')) {
    $('#nav-sync').css('top','30px');
  } else {
    $('#nav-sync').css('top','5px');
  }
  showRoot();
}

function showNode(o, node, index, hash)
{
  if (node && node.childrenData) {
    if (typeof(node.childrenData)==='string') {
      var varName    = node.childrenData;
      getScript(node.relpath+varName,function(){
        node.childrenData = getData(varName);
        showNode(o,node,index,hash);
      },true);
    } else {
      if (!node.childrenVisited) {
        getNode(o, node);
      }
      $(node.getChildrenUL()).css({'display':'block'});
      if (node.isLast) {
        node.plus_img.src = node.relpath+"ftv2mlastnode.png";
      } else {
        node.plus_img.src = node.relpath+"ftv2mnode.png";
      }
      node.expanded = true;
      var n = node.children[o.breadcrumbs[index]];
      if (index+1<o.breadcrumbs.length) {
        showNode(o,n,index+1,hash);
      } else {
        if (typeof(n.childrenData)==='string') {
          var varName = n.childrenData;
          getScript(n.relpath+varName,function(){
            n.childrenData = getData(varName);
            node.expanded=false;
            showNode(o,node,index,hash); // retry with child node expanded
          },true);
        } else {
          var rootBase = stripPath(o.toroot.replace(/\..+$/, ''));
          if (rootBase=="index" || rootBase=="pages" || rootBase=="search") {
            expandNode(o, n, true, true);
          }
          selectAndHighlight(hash,n);
        }
      }
    }
  } else {
    selectAndHighlight(hash);
  }
}

function removeToInsertLater(element) {
  var parentNode = element.parentNode;
  var nextSibling = element.nextSibling;
  parentNode.removeChild(element);
  return function() {
    if (nextSibling) {
      parentNode.insertBefore(element, nextSibling);
    } else {
      parentNode.appendChild(element);
    }
  };
}

function getNode(o, po)
{
  var insertFunction = removeToInsertLater(po.li);
  po.childrenVisited = true;
  var l = po.childrenData.length-1;
  for (var i in po.childrenData) {
    var nodeData = po.childrenData[i];
    po.children[i] = newNode(o, po, nodeData[0], nodeData[1], nodeData[2],
      i==l);
  }
  insertFunction();
}

function gotoNode(o,subIndex,root,hash,relpath)
{
  var nti = navTreeSubIndices[subIndex][root+hash];
  o.breadcrumbs = $.extend(true, [], nti ? nti : navTreeSubIndices[subIndex][root]);
  if (!o.breadcrumbs && root!=NAVTREE[0][1]) { // fallback: show index
    navTo(o,NAVTREE[0][1],"",relpath);
    $('.item').removeClass('selected');
    $('.item').removeAttr('id');
  }
  if (o.breadcrumbs) {
    o.breadcrumbs.unshift(0); // add 0 for root node
    showNode(o, o.node, 0, hash);
  }
}

function navTo(o,root,hash,relpath)
{
  var link = cachedLink();
  if (link) {
    var parts = link.split('#');
    root = parts[0];
    if (parts.length>1) hash = '#'+parts[1].replace(/[^\w\-]/g,'');
    else hash='';
  }
  if (hash.match(/^#l\d+$/)) {
    var anchor=$('a[name='+hash.substring(1)+']');
    glowEffect(anchor.parent(),1000); // line number
    hash=''; // strip line number anchors
  }
  var url=root+hash;
  var i=-1;
  while (NAVTREEINDEX[i+1]<=url) i++;
  if (i==-1) { i=0; root=NAVTREE[0][1]; } // fallback: show index
  if (navTreeSubIndices[i]) {
    gotoNode(o,i,root,hash,relpath)
  } else {
    getScript(relpath+'navtreeindex'+i,function(){
      navTreeSubIndices[i] = eval('NAVTREEINDEX'+i);
      if (navTreeSubIndices[i]) {
        gotoNode(o,i,root,hash,relpath);
      }
    },true);
  }
}

function showSyncOff(n,relpath)
{
    n.html('<img src="'+relpath+'sync_off.png" title="'+SYNCOFFMSG+'"/>');
}

function showSyncOn(n,relpath)
{
    n.html('<img src="'+relpath+'sync_on.png" title="'+SYNCONMSG+'"/>');
}

function toggleSyncButton(relpath)
{
  var navSync = $('#nav-sync');
  if (navSync.hasClass('sync')) {
    navSync.removeClass('sync');
    showSyncOff(navSync,relpath);
    storeLink(stripPath2(pathName())+hashUrl());
  } else {
    navSync.addClass('sync');
    showSyncOn(navSync,relpath);
    deleteLink();
  }
}

function initNavTree(toroot,relpath)
{
  var o = new Object();
  o.toroot = toroot;
  o.node = new Object();
  o.node.li = document.getElementById("nav-tree-contents");
  o.node.childrenData = NAVTREE;
  o.node.children = new Array();
  o.node.childrenUL = document.createElement("ul");
  o.node.getChildrenUL = function() { return o.node.childrenUL; };
  o.node.li.appendChild(o.node.childrenUL);
  o.node.depth = 0;
  o.node.relpath = relpath;
  o.node.expanded = false;
  o.node.isLast = true;
  o.node.plus_img = document.createElement("img");
  o.node.plus_img.src = relpath+"ftv2pnode.png";
  o.node.plus_img.width = 16;
  o.node.plus_img.height = 22;

  if (localStorageSupported()) {
    var navSync = $('#nav-sync');
    if (cachedLink()) {
      showSyncOff(navSync,relpath);
      navSync.removeClass('sync');
    } else {
      showSyncOn(navSync,relpath);
    }
    navSync.click(function(){ toggleSyncButton(relpath); });
  }

  $(window).load(function(){
    navTo(o,toroot,hashUrl(),relpath);
    showRoot();
  });

  $(window).bind('hashchange', function(){
     if (window.location.hash && window.location.hash.length>1){
       var a;
       if ($(location).attr('hash')){
         var clslink=stripPath(pathName())+':'+hashValue();
         a=$('.item a[class$="'+clslink.replace(/</g,'\\3c ')+'"]');
       }
       if (a==null || !$(a).parent().parent().hasClass('selected')){
         $('.item').removeClass('selected');
         $('.item').removeAttr('id');
       }
       var link=stripPath2(pathName());
       navTo(o,link,hashUrl(),relpath);
     } else if (!animationInProgress) {
       $('#doc-content').scrollTop(0);
       $('.item').removeClass('selected');
       $('.item').removeAttr('id');
       navTo(o,toroot,hashUrl(),relpath);
     }
  })
}

